#include <math.h>
using namespace std;

class cmplx
{
	double Re;
	double Im;

public:
	cmplx() {Re=0.0;Im=0.0;}
	cmplx(double NewRe, double NewIm) {Re=NewRe; Im=NewIm;}
	cmplx(double NewRe) {Re=NewRe; Im=0.0;}

	double GetRe()  const {return Re;}
	double GetIm()  const {return Im;}
	double GetAbs() const {return sqrt(Re*Re+Im*Im);}
	double GetPhi() const {return atan(Im/Re);}
	double AbsSqr() const {return Re*Re+Im*Im;}
	cmplx  Conj()   const {return cmplx(Re,-Im);}

	void SetRe (double NewRe)  {Re=NewRe;}
	void SetIm (double NewIm)  {Im=NewIm;}
	void SetAbs(double NewAbs) {double OldAbs=GetAbs(); Re *= NewAbs/OldAbs; Im *= NewAbs/OldAbs;}
	void SetPhi(double NewPhi) {double OldAbs=GetAbs(); Re = cos(NewPhi)*OldAbs; Im = sin(NewPhi)*OldAbs;}

	cmplx& operator+= (const cmplx& c) {Re+=c.Re; Im+=c.Im; return *this;}
	cmplx& operator-= (const cmplx& c) {Re-=c.Re; Im-=c.Im; return *this;}
	cmplx& operator*= (const cmplx& c) {double OldRe=Re; Re=OldRe*c.Re-Im*c.Im; Im=OldRe*c.Im+Im*c.Re; return *this;}
	cmplx& operator/= (const cmplx& c) {double OldRe=Re; Re=OldRe*c.Re+Im*c.Im; Im=Im*c.Re-OldRe*c.Im;
	                                    OldRe=c.AbsSqr(); Re/=OldRe; Im/=OldRe; return *this;}

	friend cmplx operator+ (const cmplx &a, const cmplx &b);
	friend cmplx operator- (const cmplx &a, const cmplx &b);
	friend cmplx operator* (const cmplx &a, const cmplx &b);
	friend cmplx operator/ (const cmplx &a, const double &b);
	friend cmplx operator/ (const cmplx &a, const cmplx &b);
	friend ostream& operator<< (ostream &os, const cmplx &c);
};


cmplx operator+ (const cmplx &a, const cmplx &b) {return cmplx(a.Re+b.Re,a.Im+b.Im);}
cmplx operator- (const cmplx &a, const cmplx &b) {return cmplx(a.Re-b.Re,a.Im-b.Im);}
cmplx operator* (const cmplx &a, const cmplx &b) {return cmplx(a.Re*b.Re-a.Im*b.Im,a.Re*b.Im+a.Im*b.Re);}
cmplx operator/ (const cmplx &a, const double &b) {return cmplx(a.Re/b,a.Im/b);}
cmplx operator/ (const cmplx &a, const cmplx &b) {return a*b.Conj()/b.AbsSqr();}


ostream& operator<< (ostream &os, const cmplx &c)
{
	if (c.Im<0)
		os << c.Re << "-i" << -c.Im;
	else
		os << c.Re << "+i" <<  c.Im;
	return os;
}
